<?php  
/* 
Plugin Name: VC Violet Background
Version: 1.1.1
Author: Boom-Apps
Author URI: http://boomapps.eu
Description: Animated background for Visual Composer Row
*/  

class VC_Violet_Background {
	function backendElement() {
		vc_map( array(
            "name" => __("VC Violet Background", 'vc_extend'),
            "description" => __("Creative backgrounds!", 'vc_extend'),
            "base" => "vc_violet_background",
            "class" => "",
            "controls" => "full",
            "params" => array(
              array("save_always" => true, "type" => "textarea", "holder" => "div", "class" => "", "heading" => "Id - unique per page", "param_name" => "theid", "value" => "vcvioletbackground_".time()."_".rand(100000,999999999) ),
			  array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Trail count", "param_name" => "trails", "value" => "20", "description" => "Integer (1-500)" ),
              array("save_always" => true, "type" => "dropdown", "class" => "", "heading" => "Animate color?", "param_name" => "fixedhue", "value" => array( "No" => "true", "Yes" => "false") ),
              array("save_always" => true, "dependency" => array("element" => "fixedhue", "value" => "true"), "type" => "textarea", "class" => "", "heading" => "Fixed hue", "param_name" => "hue", "value" => "20", "description" => "Integer (0-360). Only for fixed color" ),
              array("save_always" => true, "dependency" => array("element" => "fixedhue", "value" => "false"), "type" => "textarea", "class" => "", "heading" => "Hue speed", "param_name" => "huespeed", "value" => ".003", "description" => "Float (0.000 - 1.000). Only for animated color" ),
              array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Saturation", "param_name" => "saturation", "value" => "90", "description" => "Integer (0 - 100)" ),
              array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Lightness", "param_name" => "lightness", "value" => "50", "description" => "Integer (0 - 100)" ),
              array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Opacity", "param_name" => "huespeed", "value" => ".25", "description" => "Float (0.00 - 1.00)" ),
              array("save_always" => true, "type" => "colorpicker", "class" => "", "heading" => "Background color", "param_name" => "bgcolor", "value" => "#000000" ),
             
            )
        ) );
		

	}
	function theShortcode($Atts, $Content = null) {
		wp_enqueue_script(  array( 'jquery','ultraviolet','vc-violet-background' ) );
		wp_enqueue_style(  array( 'vc-violet-background' ) );
		
		
		$RGBBg = self::convertColors($Atts['bgcolor']);
		
		$Atts['bgr'] = $RGBBg['red'];
		$Atts['bgg'] = $RGBBg['green'];
		$Atts['bgb'] = $RGBBg['blue'];
		
		$Return = '<div id="'.$Atts['theid'].'" ';
		foreach ($Atts as $AttN => $AttV) {
			$Return .= 'data-'.str_replace("_","-",$AttN).'="'.$AttV.'" ';
		}
		$Return .= 'class="vc-violet-background" style="display:none;"></div>';
		
		return $Return;
	}
	
	
	function convertColors($hexStr, $returnAsString = false, $seperator = ',') {
		$hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
		$rgbArray = array();
		if (strlen($hexStr) == 6) { //If a proper hex code, convert using bitwise operation. No overhead... faster
			$colorVal = hexdec($hexStr);
			$rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
			$rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
			$rgbArray['blue'] = 0xFF & $colorVal;
		} elseif (strlen($hexStr) == 3) { //if shorthand notation, need some string manipulations
			$rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
			$rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
			$rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
		} else {
			return false; //Invalid hex color code
		}
		return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray; // returns the rgb string or the associative array
	} 
	
	function custom_css_classes_for_vc_row_and_vc_column( $class_string, $tag ) {
	  if ( $tag == 'vc_row' || $tag == 'vc_row_inner' ) {
		if (strpos($class_string,'boomapps_vcrow') == false) { $class_string = $class_string . " boomapps_vcrow"; } 
	  }
	  if ( $tag == 'vc_column' || $tag == 'vc_column_inner' ) {
		if (strpos($class_string,'boomapps_vccolumn') == false) { $class_string = $class_string . " boomapps_vccolumn"; }
	  }
	  return $class_string; 
	}
	
	function registerStuff() {
		add_shortcode( 'vc_violet_background', array($this,'theShortcode') );	
		$this->backendElement();		
	}
	function registerScripts() {
		 wp_register_script( 'ultraviolet', plugins_url('_3rdparty/ultraviolet.js',__FILE__ ) );
		 wp_register_script( 'vc-violet-background', plugins_url('vcvioletbackground.js',__FILE__ ) );
		 wp_register_style( 'vc-violet-background', plugins_url('vcvioletbackground.css',__FILE__ ) );
		
	}
	function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'registerScripts') );
		add_action( 'init', array( $this, 'registerStuff') );	
		add_filter( 'vc_shortcodes_css_class', array($this,'custom_css_classes_for_vc_row_and_vc_column'), 10, 2 );
	}
}


/* Let's go! */
if (function_exists('vc_map')) {
	new VC_Violet_Background;
}

